/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui;

import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentObject;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.api.ui.IDisplay;
import frc.emul.api.ui.IDisplayListener;
import frc.emul.periph.IAnalogPeer;
import frc.emul.vectrex.PersistenceManager;
import frc.emul.vectrex.PersistentSection;
import frc.emul.vectrex.ui.GfxItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeadlessDisplay
implements IDisplay,
IDisplay.DEBUG,
IPersistentObject {
    public List<IDisplayListener> listeners = new ArrayList<IDisplayListener>();
    private List<GfxItem> activeBuffer;
    private List<GfxItem> workBuffer;
    private GfxItem lastPoint;
    protected IAnalogPeer analogPeer;

    public HeadlessDisplay() {
        this.clearContent();
    }

    public synchronized List<GfxItem> getActiveBuffer() {
        return this.activeBuffer;
    }

    public synchronized List<GfxItem> getWorkBuffer() {
        return this.workBuffer;
    }

    public synchronized List<GfxItem> getWorkBufferCopy(boolean bl) {
        List<GfxItem> list = this.workBuffer;
        int n = list.size();
        ArrayList<GfxItem> arrayList = new ArrayList<GfxItem>(n + 1);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(list.get(n2).clone());
            ++n2;
        }
        if (bl && this.analogPeer != null) {
            this.workBuffer = arrayList;
            this.analogPeer.flushCurrentLine();
            this.workBuffer = list;
        }
        return arrayList;
    }

    public synchronized void getBeamPosition(GfxItem gfxItem) {
        if (this.analogPeer != null) {
            this.analogPeer.getBeamPosition(gfxItem);
        } else {
            gfxItem.x0 = 0.0f;
            gfxItem.y0 = 0.0f;
        }
    }

    protected void switchingBuffers(List<GfxItem> list) {
    }

    protected synchronized void setActiveBuffer(List<GfxItem> list) {
        this.activeBuffer = list;
    }

    protected synchronized void setWorkBuffer(List<GfxItem> list) {
        this.workBuffer = list;
    }

    @Override
    public void setAnalogPeer(IAnalogPeer iAnalogPeer) {
        this.analogPeer = iAnalogPeer;
    }

    @Override
    public boolean tick(int n) {
        return true;
    }

    @Override
    public synchronized void clearContent() {
        this.activeBuffer = new ArrayList<GfxItem>();
        this.workBuffer = new ArrayList<GfxItem>();
        GfxItem.clearPool();
    }

    @Override
    public synchronized void frameCompleted(int n) {
        if (this.listeners != null) {
            for (IDisplayListener object2 : this.listeners) {
                object2.frameCompleted();
            }
        }
        List<GfxItem> list = this.activeBuffer;
        this.activeBuffer = this.workBuffer;
        this.workBuffer = list;
        this.switchingBuffers(this.activeBuffer);
        GfxItem.freeItems(this.workBuffer);
    }

    @Override
    public void addLine(float f, float f2, float f3, float f4, int n) {
        this.workBuffer.add(GfxItem.newLine(f, f2, f3, f4, n));
    }

    @Override
    public void addPoint(float f, float f2, int n) {
        this.lastPoint = GfxItem.newPoint(f, f2, n);
        this.workBuffer.add(this.lastPoint);
    }

    @Override
    public synchronized void addDisplayListener(IDisplayListener iDisplayListener) {
        this.listeners.add(iDisplayListener);
    }

    @Override
    public synchronized void removeDisplayListener(IDisplayListener iDisplayListener) {
        this.listeners.remove(iDisplayListener);
    }

    @Override
    public void removeLastPoint() {
        try {
            if (this.lastPoint != null) {
                this.workBuffer.remove(this.lastPoint);
                GfxItem.freeItem(this.lastPoint);
                this.lastPoint = null;
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public int getPointsCount() {
        int n = 0;
        int n2 = this.workBuffer.size();
        while (--n2 >= 0) {
            if (!this.workBuffer.get(n2).isPoint()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getLinesCount() {
        int n = 0;
        int n2 = this.workBuffer.size();
        while (--n2 >= 0) {
            if (this.workBuffer.get(n2).isPoint()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public IPersistentSection getSection() {
        return PersistentSection.DISPLAY;
    }

    @Override
    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.openSection(PersistentSection.DISP_BUFF_WORK);
        HeadlessDisplay.store(iPersistenceWriter, this.workBuffer);
        iPersistenceWriter.closeSection();
        iPersistenceWriter.write16(this.workBuffer.indexOf(this.lastPoint));
    }

    @Override
    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.openSection(PersistentSection.DISP_BUFF_WORK);
        HeadlessDisplay.load(iPersistenceReader, this.workBuffer);
        iPersistenceReader.closeSection();
        int n = iPersistenceReader.readS16();
        this.lastPoint = n < 0 ? null : this.workBuffer.get(n);
    }

    protected void setPaused(boolean bl) {
        if (this.listeners != null) {
            for (IDisplayListener iDisplayListener : this.listeners) {
                iDisplayListener.pauseStatusUpdate(bl);
            }
        }
    }

    public static final void store(IPersistenceWriter iPersistenceWriter, List<GfxItem> list) throws PersistenceException {
        iPersistenceWriter.write16(list.size());
        int n = 0;
        while (n < list.size()) {
            GfxItem gfxItem = list.get(n);
            iPersistenceWriter.write(gfxItem);
            ++n;
        }
    }

    public static final void load(IPersistenceReader iPersistenceReader, List<GfxItem> list) throws PersistenceException {
        GfxItem.freeItems(list);
        int n = iPersistenceReader.readU16();
        while (n-- > 0) {
            GfxItem gfxItem = GfxItem.allocItem();
            iPersistenceReader.read(gfxItem);
            list.add(gfxItem);
        }
    }

    public static final List<GfxItem> loadGraphics(File file) throws PersistenceException {
        List<GfxItem> list;
        block7: {
            IPersistenceReader iPersistenceReader = null;
            try {
                iPersistenceReader = PersistenceManager.open(null, file);
                list = HeadlessDisplay.loadGraphics(iPersistenceReader);
                if (iPersistenceReader == null) break block7;
            }
            catch (Throwable throwable) {
                if (iPersistenceReader != null) {
                    try {
                        iPersistenceReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                iPersistenceReader.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public static final List<GfxItem> loadGraphics(IPersistenceReader iPersistenceReader) throws PersistenceException {
        try {
            int n = iPersistenceReader.fetchSection(PersistentSection.DISPLAY, PersistentSection.DISP_BUFF_ACTIVE);
            ArrayList<GfxItem> arrayList = new ArrayList<GfxItem>(n / 24 + 1);
            HeadlessDisplay.load(iPersistenceReader, arrayList);
            return arrayList;
        }
        catch (PersistenceException persistenceException) {
            throw persistenceException;
        }
        catch (Exception exception) {
            throw new PersistenceException("File-Seek", "Error while loading graphics from save file", exception);
        }
    }
}

